<?php
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreVetrina extends VisualizzatoreComponente {
        private $javascriptAssociato;
        
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            $vetrina = parent::getDb()->leggiSingolaRiga("geec_vetrineScorrevoli",$dati["idElemento"]);
            $classeContenitore = ($vetrina["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
            $altezzaSlider = $vetrina["altezza"];
            $idVetrina = str_replace(" ", "", $vetrina["nome"]);
            echo"<section id=\"{$dati["idSezione"]}\" class=\"{$dati["classeSezione"]}\">
                    <div class=\"$classeContenitore noPadding\">
                        <div class=\"row row-negative-margin\">
                            <div class=\"col-xs-12\">
                                <div class=\"slider-new $altezzaSlider\">
                                    <div id=\"$idVetrina\" class=\"owl-carousel owl-theme slider-multiplo\">";
                                    $this->stampaElementi($dati);
                                echo"</div>
                                </div>
                            </div>
                        </div>
                    </div>";		

            //chiudo il div carousel inner, creo le frecce e chiudo il div principale dello slider
            echo"</div>";
            echo"</section>";
            
            $this->javascriptAssociato = $this->generaJavascriptVetrina($vetrina,$idVetrina);
        }
        
        //metodo che crea le slide
        function stampaElementi($dati) {
            $querySlide="SELECT * FROM geec_elementoVetrina WHERE idVetrina={$dati["idElemento"]} ORDER BY posizione";
            $risSlide = parent::getDb()->eseguiQueryLettura($querySlide);

            if($risSlide->num_rows==0) {
                echo"<h2>Attenzione, non sono presenti elementi nella vetrina. Crearle dal pannello amministrativo</h2>";
            }

            while($elemento=$risSlide->fetch_assoc()) {
                $this->stampaElemento($elemento);
            }
        }
        
        function stampaElemento($elemento) {
            if($elemento["link"]!=""){
                echo "<a href=\"{$elemento["link"]}\">
                   <div class=\"item img-background\" style=\"background-image: url('{$elemento["immagine"]}')\"></div>
               </a>\n";
            }
            else {
                echo "<div class=\"item img-background\" style=\"background-image: url('{$elemento["immagine"]}')\"></div>\n";
            }
        }
        
        function generaJavascriptVetrina($vetrina,$idVetrina) {
            $numeroOggettiTablet = ($vetrina["elementiPerSlide"] == 1) ? 1 : $vetrina["elementiPerSlide"]-1;
            return "<script>
                    $(document).ready(function() {
                        $('#$idVetrina').owlCarousel({
                            loop:true,
                            margin:10,
                            responsiveClass:true,
                            responsive:{
                                0:{
                                    items:1,
                                    nav:true
                                },
                                600:{
                                    items:$numeroOggettiTablet,
                                    nav:false
                                },
                                1000:{
                                    items:{$vetrina["elementiPerSlide"]},
                                    nav:true,
                                }
                            }
                        });
                    });
                </script>";
        }
        
        function getJavascriptAssociato() {
            return $this->javascriptAssociato;
        }
    }
